/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.xml;

import cz.insophy.inplan.xml.ConversionException;
import cz.insophy.inplan.xml.SuperplanConverter;
import cz.insophy.inplan.xml.XmlSource;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XsltSuperplanConverter
implements SuperplanConverter {
    private final int fromVersion;
    private final int toVersion;
    private final String xsltPath;

    public XsltSuperplanConverter(int fromVersion) {
        this.fromVersion = fromVersion;
        this.toVersion = fromVersion + 1;
        this.xsltPath = "plan-" + fromVersion + ".x.xslt";
    }

    @Override
    public XmlSource convert(XmlSource source) throws ConversionException {
        StringReader resultReader = null;
        try {
            Source xmlSource = source.getJavaxSource();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource xslt = new StreamSource(XsltSuperplanConverter.class.getResourceAsStream(this.xsltPath));
            StringWriter resultWriter = new StringWriter();
            StreamResult result = new StreamResult(resultWriter);
            Transformer transformer = transformerFactory.newTransformer(xslt);
            transformer.transform(xmlSource, result);
            resultReader = new StringReader(resultWriter.toString());
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
        source.closeSource();
        return XmlSource.create(resultReader);
    }

    @Override
    public int getFromVersion() {
        return this.fromVersion;
    }

    @Override
    public int getToVersion() {
        return this.toVersion;
    }
}

